<?php
/**
 * Copyright © 2017 MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\OptionFeatures\Model;

use Magento\Framework\Model\AbstractModel;

class OptionDescription extends AbstractModel
{
    public const TABLE_NAME = 'mageworx_optionfeatures_option_description';
    public const OPTIONTEMPLATES_TABLE_NAME = 'mageworx_optiontemplates_group_option_description';

    public const COLUMN_NAME_OPTION_DESCRIPTION_ID = 'option_description_id';
    public const COLUMN_NAME_OPTION_ID             = 'option_id';
    public const COLUMN_NAME_STORE_ID       = 'store_id';
    public const COLUMN_NAME_DESCRIPTION = 'description';

    public const FIELD_OPTION_ID_ALIAS = 'mageworx_description_option_id';

    /**
     * Set resource model and Id field name
     *
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->_init('MageWorx\OptionFeatures\Model\ResourceModel\OptionDescription');
        $this->setIdFieldName(self::COLUMN_NAME_OPTION_DESCRIPTION_ID);
    }
}
