define(['Magento_Ui/js/grid/columns/column'], function (Column) 
{
    'use strict';

    return Column.extend(
	{
        defaults: 
		{
            bodyTmpl: 'Anowave_Ec/order/grid/cell/consent.html',
            itemsToDisplay: 5
        },
        getTooltipData: function (record) 
		{
			let data = JSON.parse(record[this.index]);

			let render = [];

			Object.entries(data).forEach(([key, value]) => 
			{
				render.push('<span data-consent="' + value + '">' + key + '</span>');

				console.debug('<span data-consent="' + value + '">' + key + '</span>');
			});

			return render;
        },
        getConsent: function (record) 
		{
			if (record.consent)
			{
				return JSON.parse(record.consent);
			}

			return [];
        },
		hasConsent: function(record)
		{
			return record.consent;
		}
    });
});
