<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\App\Action\Context;
use Anowave\Ec\Helper\Data;
use Anowave\Ec\Model\Api\TikTok\Api;

class TikTok extends Action
{
    /**
     * @var JsonFactory
     */
    protected $resultJsonFactory;
    
    /**
     * @var \Anowave\Ec\Helper\Data
     */
    protected $helper;
    
    /**
     * @var Api
     */
    protected $api;

    /**
     * Constructor
     *
     * @param Context $context
     * @param JsonFactory $resultJsonFactory
     * @param \Anowave\Ec\Helper\Data $helper
     */
    public function __construct
    (
        Context $context,
        JsonFactory $resultJsonFactory,
        Data $helper,
        Api $api
    )
    {
        parent::__construct($context);
        
        /**
         * Set response type factory
         *
         * @var JsonFactory
         */
        $this->resultJsonFactory = $resultJsonFactory;
        
        /**
         * Set helper
         *
         * @var \Anowave\Ec\Helper\Data
         */
        $this->helper = $helper;

        $this->api = $api;
    }
    
    /**
     * Execute controller
     *
     * @see \Magento\Framework\App\ActionInterface::execute()
     */
    public function execute()
    {
        return $this->resultJsonFactory->create()->setData
        (
            [
                'success' => true
            ]
        );
    }
}