<?php
namespace Magento\Framework\Oauth\Helper\Request;

/**
 * Proxy class for @see \Magento\Framework\Oauth\Helper\Request
 */
class Proxy extends \Magento\Framework\Oauth\Helper\Request implements \Magento\Framework\ObjectManager\NoninterceptableInterface
{
    /**
     * Object Manager instance
     *
     * @var \Magento\Framework\ObjectManagerInterface
     */
    protected $_objectManager = null;

    /**
     * Proxied instance name
     *
     * @var string
     */
    protected $_instanceName = null;

    /**
     * Proxied instance
     *
     * @var \Magento\Framework\Oauth\Helper\Request
     */
    protected $_subject = null;

    /**
     * Instance shareability flag
     *
     * @var bool
     */
    protected $_isShared = null;

    /**
     * Proxy constructor
     *
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     * @param string $instanceName
     * @param bool $shared
     */
    public function __construct(\Magento\Framework\ObjectManagerInterface $objectManager, $instanceName = '\\Magento\\Framework\\Oauth\\Helper\\Request', $shared = true)
    {
        $this->_objectManager = $objectManager;
        $this->_instanceName = $instanceName;
        $this->_isShared = $shared;
    }

    /**
     * @return array
     */
    public function __sleep()
    {
        return ['_subject', '_isShared', '_instanceName'];
    }

    /**
     * Retrieve ObjectManager from global scope
     */
    public function __wakeup()
    {
        $this->_objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * Clone proxied instance
     */
    public function __clone()
    {
        if ($this->_subject) {
            $this->_subject = clone $this->_getSubject();
        }
    }

    /**
     * Debug proxied instance
     */
    public function __debugInfo()
    {
        return ['i' => $this->_subject];
    }

    /**
     * Get proxied instance
     *
     * @return \Magento\Framework\Oauth\Helper\Request
     */
    protected function _getSubject()
    {
        if (!$this->_subject) {
            $this->_subject = true === $this->_isShared
                ? $this->_objectManager->get($this->_instanceName)
                : $this->_objectManager->create($this->_instanceName);
        }
        return $this->_subject;
    }

    /**
     * {@inheritdoc}
     */
    public function prepareRequest($httpRequest)
    {
        return $this->_getSubject()->prepareRequest($httpRequest);
    }

    /**
     * {@inheritdoc}
     */
    public function getRequestUrl($httpRequest)
    {
        return $this->_getSubject()->getRequestUrl($httpRequest);
    }

    /**
     * {@inheritdoc}
     */
    public function prepareErrorResponse(\Exception $exception, ?\Magento\Framework\HTTP\PhpEnvironment\Response $response = null)
    {
        return $this->_getSubject()->prepareErrorResponse($exception, $response);
    }
}
