<?php
/**
 * @category    WeltPixel
 * @package     WeltPixel_SocialLogin
 * @copyright   Copyright (c) 2018 WeltPixel
 * @author      WeltPixel TEAM
 */


namespace WeltPixel\SocialLogin\Ui\Component\Listing\Column;

use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class Type
 * @package WeltPixel\SocialLogin\Ui\Component\Listing\Column
 */
class Type extends Column
{
    /**
     * @var array
     */
    protected $_typeMapping = [
        'fb' => 'Facebook',
        'instagram' => 'Instagram',
        'amazon' => 'Amazon',
        'google' => 'Google',
        'twitter' => 'Twitter',
        'linkedin' => 'LinkedIn',
        'paypal' => 'PayPal'
    ];
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param ContextInterface      $context
     * @param UiComponentFactory    $uiComponentFactory
     * @param StoreManagerInterface $storeManager
     * @param array                 $components
     * @param array                 $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        StoreManagerInterface $storeManager,
        array $components = [],
        array $data = []
    ) {
        $this->storeManager = $storeManager;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            $fieldName = $this->getData('name');
            foreach ($dataSource['data']['items'] as & $item) {
                $type = '';
                if ($item[$fieldName] != '') {
                    $type = $this->_typeMapping[$item['type']];
                }

                $item[$fieldName] = $type;
            }
        }

        return $dataSource;
    }

}