<?php
namespace WeltPixel\OwlCarouselSlider\Block\Adminhtml\System;

class Messages extends \Magento\Backend\Block\Template
{
    /**
     * @var \Magento\Framework\Module\Manager
     */
    protected $moduleManager;

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Module\Manager $moduleManager
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Module\Manager $moduleManager,
        array $data = []
    ) {
        $this->moduleManager = $moduleManager;
        parent::__construct($context, $data);
    }

    /**
     * @return string
     */
    protected function _toHtml()
    {
        if ($this->moduleManager->isEnabled('WeltPixel_MobileDetect')) {
            return '';
        }

        $message = 'The Mobile Detect extension is not enabled or installed. This extension is required for proper Owl Carousel & Banner Slider PRO functionality. You can find the Mobile Detect extension files in the Owl Carousel & Banner Slider PRO extension package you downloaded from weltpixel.com.';

        return '<div class="messages">
                    <div class="message message-warning warning">
                        <div data-ui-id="messages-message-warning">' . $message . '</div>
                    </div>
                </div>';
    }
}
