<?php
/**
 * Mageplaza
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Mageplaza.com license that is
 * available through the world-wide-web at this URL:
 * https://www.mageplaza.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Mageplaza
 * @package     Mageplaza_CustomForm
 * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)
 * @license     https://www.mageplaza.com/LICENSE.txt
 */

namespace Mageplaza\CustomForm\Ui\Component\Listing\Columns;

use Exception;
use Magento\Customer\Helper\View;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Model\Data\CustomerFactory;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Psr\Log\LoggerInterface;
/**
 * Class Customer
 * @package Mageplaza\CustomForm\Ui\Component\Listing\Columns
 */
class Customer extends Column
{
    /**
     * @var View
     */
    private $customerHelper;

    /**
     * @var CustomerRepositoryInterface
     */
    private $customerRepository;

    /**
     * @var CustomerFactory
     */
    private $customerFactory;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * Customer constructor.
     *
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param CustomerRepositoryInterface $customerRepository
     * @param CustomerFactory $customerFactory
     * @param View $customerHelper
     * @param LoggerInterface $logger
     * @param array $components
     * @param array $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        CustomerRepositoryInterface $customerRepository,
        CustomerFactory $customerFactory,
        View $customerHelper,
        LoggerInterface $logger,
        array $components = [],
        array $data = []
    ) {
        $this->customerRepository = $customerRepository;
        $this->customerHelper     = $customerHelper;
        $this->customerFactory    = $customerFactory;
        $this->logger             = $logger;

        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items']) && is_array($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                if ($item['customer_id']) {
                    try {
                        if ($this->customerRepository->getById($item['customer_id'])) {
                            $item[$this->getData('name')] =
                                $this->getCustomerName($item) . ' <' . $item[$this->getData('name')] . '>';
                        }
                    } catch (Exception $e) {
                        $this->logger->critical($e);
                        $item[$this->getData('name')] = __('This customer account no longer exists.');
                    }
                } else {
                    $item[$this->getData('name')] = __('Guest');
                }
            }
        }

        return $dataSource;
    }

    /**
     * @param $item
     *
     * @return string
     */
    private function getCustomerName($item)
    {
        $item['id'] = $item['customer_id'];
        $customer = $this->customerFactory->create(['data' => $item]);

        return $this->customerHelper->getCustomerName($customer);
    }
}
