<?php
/**
 * Mageplaza
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Mageplaza.com license that is
 * available through the world-wide-web at this URL:
 * https://www.mageplaza.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Mageplaza
 * @package     Mageplaza_CustomForm
 * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)
 * @license     https://www.mageplaza.com/LICENSE.txt
 */

namespace Mageplaza\CustomForm\Block\Hyva;

use Mageplaza\CustomForm\Block\CustomForm;
use Mageplaza\CustomForm\Model\Form as CustomFormModel;

/**
 * Class Preview
 * @package Mageplaza\CustomForm\Block\Hyva
 */
class Preview extends CustomForm
{
    /**
     * @var string
     */
    protected $_template = 'Mageplaza_CustomForm::hyva/preview.phtml';

    /**
     * @return string
     */
    public function getTemplate(): string
    {
        if ($this->helperData->checkHyvaTheme()) {
            return 'Mageplaza_CustomForm::hyva/preview.phtml';
        }

        return 'Mageplaza_CustomForm::preview.phtml';
    }

    /**
     * @return CustomFormModel
     */
    public function loadCustomForm()
    {
        $data = $this->request->getParam('form');
        /** @var CustomFormModel $customForm */
        $customForm = $this->customFormFactory->create();
        $customForm->setData($data);
        $customForm->setCustomerGroupIds(['0']);

        return $customForm;
    }
}
