<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Ui\DataProvider\Rate\Form;

use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Ui\DataProvider\AbstractDataProvider;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;
use Magento\Ui\DataProvider\Modifier\PoolInterface;
use MageWorx\ShippingRules\Model\Carrier\Method\Rate;
use MageWorx\ShippingRules\Model\ResourceModel\Rate\CollectionFactory;

class RateDataProvider extends AbstractDataProvider
{
    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * @var DataPersistorInterface
     */
    protected $dataPersistor;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var PoolInterface
     */
    protected $pool;

    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param CollectionFactory $collectionFactory
     * @param PoolInterface $pool
     * @param RequestInterface $request
     * @param DataPersistorInterface $dataPersistor
     * @param StoreManagerInterface $storeManager
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $collectionFactory,
        PoolInterface $pool,
        RequestInterface $request,
        DataPersistorInterface $dataPersistor,
        StoreManagerInterface $storeManager,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
        $this->pool         = $pool;
        $this->request      = $request;
        $this->storeManager = $storeManager;
        $this->collection   = $collectionFactory->create();
    }

    /**
     * Get meta from all modifiers
     *
     * @return array
     * @throws LocalizedException
     */
    public function getMeta()
    {
        $meta      = parent::getMeta();
        $modifiers = $this->pool->getModifiersInstances();
        /** @var ModifierInterface $modifier */
        foreach ($modifiers as $modifier) {
            $meta = $modifier->modifyMeta($meta);
        }

        return $meta;
    }

    /**
     * Get data from all modifiers and items from the collection
     *
     * @return array
     * @throws LocalizedException
     */
    public function getData()
    {
        if (!empty($this->data)) {
            return $this->data;
        }
        $items = $this->collection->getItems();
        /** @var Rate $rate */
        foreach ($items as $rate) {
            $rate->getResource()->afterLoad($rate);
            $this->data[$rate->getId()] = $rate->getData();
            // Workaround for the magento bug with multiselect values when it expect integer values, but got string
            if (!empty($this->data[$rate->getId()]['region_id'])) {
                foreach ($this->data[$rate->getId()]['region_id'] as $key => $region) {
                    $this->data[$rate->getId()]['region_id'][$key] = (int)$region;
                }
            }

            if (!empty($this->data[$rate->getId()]['plain_zip_codes'])) {
                $zips          = [];
                $inverted      = 0;
                $plainZipCodes = $this->data[$rate->getId()]['plain_zip_codes'];
                foreach ($plainZipCodes as $zipCode) {
                    $zips[] = $zipCode['zip'];
                    if (!$inverted) {
                        $inverted = $zipCode['inverted'];
                    }
                }
                $this->data[$rate->getId()]['plain_zip_codes_inversion'] = $inverted;
                $this->data[$rate->getId()]['plain_zip_codes_string']    = implode(',', $zips);
            }
        }

        $modifiers = $this->pool->getModifiersInstances();
        /** @var ModifierInterface $modifier */
        foreach ($modifiers as $modifier) {
            $this->data = $modifier->modifyData($this->data);
        }

        return $this->data;
    }
}
