<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Ui\DataProvider\Method\Form;

use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Ui\DataProvider\AbstractDataProvider;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;
use Magento\Ui\DataProvider\Modifier\PoolInterface;
use MageWorx\ShippingRules\Model\Carrier\Method;
use MageWorx\ShippingRules\Model\ResourceModel\Method\CollectionFactory;

class MethodDataProvider extends AbstractDataProvider
{
    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * @var DataPersistorInterface
     */
    protected $dataPersistor;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var PoolInterface
     */
    protected $pool;

    /**
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param CollectionFactory $collectionFactory
     * @param PoolInterface $pool
     * @param RequestInterface $request
     * @param DataPersistorInterface $dataPersistor
     * @param StoreManagerInterface $storeManager
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $collectionFactory,
        PoolInterface $pool,
        RequestInterface $request,
        DataPersistorInterface $dataPersistor,
        StoreManagerInterface $storeManager,
        array $meta = [],
        array $data = []
    ) {
        // Use alternative field name in case id is not set
        if (!$request->getParam($requestFieldName)) {
            $primaryFieldName = 'code';
            $requestFieldName = 'code';
        }
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
        $this->pool         = $pool;
        $this->request      = $request;
        $this->storeManager = $storeManager;
        $this->collection   = $collectionFactory->create();
    }

    /**
     * Get meta from all modifiers
     *
     * @return array
     * @throws LocalizedException
     */
    public function getMeta()
    {
        $meta      = parent::getMeta();
        $modifiers = $this->pool->getModifiersInstances();
        /** @var ModifierInterface $modifier */
        foreach ($modifiers as $modifier) {
            $meta = $modifier->modifyMeta($meta);
        }

        return $meta;
    }

    /**
     * Get data from all modifiers and items from the collection
     *
     * @return array
     * @throws LocalizedException
     */
    public function getData()
    {
        if (!empty($this->data)) {
            return $this->data;
        }
        $items         = $this->collection->getItems();
        $isSingleStore = $this->storeManager->isSingleStoreMode();
        /** @var Method $method */
        foreach ($items as $method) {
            $key                              = $method->getData($this->primaryFieldName);
            $this->data[$key]                 = $method->getData();
            $this->data[$key]['single_store'] = $isSingleStore;
        }

        $modifiers = $this->pool->getModifiersInstances();
        /** @var ModifierInterface $modifier */
        foreach ($modifiers as $modifier) {
            $this->data = $modifier->modifyData($this->data);
        }

        return $this->data;
    }
}
