<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Model\Rule\Condition;

use Magento\Framework\DataObject;
use Magento\Framework\DataObjectFactory;
use Magento\Framework\Event\ManagerInterface;
use Magento\Rule\Model\Condition\Context;

class Combine extends \Magento\SalesRule\Model\Rule\Condition\Combine
{
    /**
     * @var DataObjectFactory
     */
    protected $dataObjectFactory;

    /**
     * @var Customer
     */
    protected $conditionCustomer;

    /**
     * Combine constructor.
     *
     * @param Context $context
     * @param ManagerInterface $eventManager
     * @param Address $conditionAddress
     * @param DataObjectFactory $dataObjectFactory
     * @param array $data
     */
    public function __construct(
        Context           $context,
        ManagerInterface  $eventManager,
        Address           $conditionAddress,
        Customer          $conditionCustomer,
        DataObjectFactory $dataObjectFactory,
        array             $data = []
    ) {
        $this->dataObjectFactory = $dataObjectFactory;
        parent::__construct($context, $eventManager, $conditionAddress, $data);
        $this->conditionCustomer = $conditionCustomer;
        $this->setType('MageWorx\ShippingRules\Model\Rule\Condition\Combine');
    }

    /**
     * Get new child select options
     *
     * @return array
     */
    public function getNewChildSelectOptions()
    {
        $addressAttributes = $this->_conditionAddress->loadAttributeOptions()->getAttributeOption();
        $cartAttributes    = [];
        foreach ($addressAttributes as $code => $label) {
            $cartAttributes[] = [
                'value' => 'MageWorx\ShippingRules\Model\Rule\Condition\Address|' . $code,
                'label' => $label,
            ];
        }

        $customerAttributesRaw = $this->conditionCustomer->loadAttributeOptions()->getAttributeOption();
        $customerAttributes    = [];
        foreach ($customerAttributesRaw as $code => $label) {
            $customerAttributes[] = [
                'value' => 'MageWorx\ShippingRules\Model\Rule\Condition\Customer|' . $code,
                'label' => $label,
            ];
        }

        $conditions = [
            [
                'value' => '',
                'label' => __('Please choose a condition to add.'),
            ],
            [
                'value' => 'MageWorx\ShippingRules\Model\Rule\Condition\Product\Found',
                'label' => __('Product attribute combination'),
            ],
            [
                'value' => 'MageWorx\ShippingRules\Model\Rule\Condition\Product\Subselect',
                'label' => __('Products subselection'),
            ],
            [
                'value' => 'MageWorx\ShippingRules\Model\Rule\Condition\Combine',
                'label' => __('Conditions combination'),
            ],
            [
                'value' => $cartAttributes,
                'label' => __('Cart Attribute'),
            ],
            [
                'value' => $customerAttributes,
                'label' => __('Customer Attributes'),
            ]
        ];

        /** @var DataObject $additional */
        $additional = $this->dataObjectFactory->create();

        $this->_eventManager->dispatch(
            'salesrule_rule_condition_combine',
            ['additional' => $additional]
        );
        $this->_eventManager->dispatch(
            'shipping_rule_condition_combine',
            ['additional' => $additional]
        );

        $additionalConditions = $additional->getConditions();
        if ($additionalConditions) {
            $conditions = array_merge_recursive(
                $conditions,
                $additionalConditions
            );
        }

        return $conditions;
    }
}
