<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Controller\Adminhtml\Shippingrules;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Registry;
use MageWorx\ShippingRules\Api\ZoneRepositoryInterface;
use MageWorx\ShippingRules\Model\Zone as ZoneModel;
use MageWorx\ShippingRules\Model\ZoneFactory;
use Psr\Log\LoggerInterface;

/**
 * Class Zone
 */
abstract class Zone extends Action
{
    /**
     * Core registry
     *
     * @var Registry
     */
    protected $coreRegistry = null;

    /**
     * @var ZoneFactory
     */
    protected $zoneFactory;

    /**
     * @var ZoneRepositoryInterface
     */
    protected $zoneRepository;

    /**
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * @param Context $context
     * @param Registry $coreRegistry
     * @param ZoneRepositoryInterface $zoneRepository
     * @param LoggerInterface $logger
     */
    public function __construct(
        Context                 $context,
        Registry                $coreRegistry,
        ZoneRepositoryInterface $zoneRepository,
        LoggerInterface         $logger
    ) {
        parent::__construct($context);
        $this->coreRegistry   = $coreRegistry;
        $this->zoneRepository = $zoneRepository;
        $this->logger         = $logger;
    }

    /**
     * Initiate zone
     *
     * @return void
     */
    protected function initZone()
    {
        $id = (int)$this->getRequest()->getParam('id');
        if (!$id && $this->getRequest()->getParam('entity_id')) {
            $id = (int)$this->getRequest()->getParam('entity_id');
        }

        if ($id) {
            $zone = $this->zoneRepository->getById($id);
        } else {
            $zone = $this->zoneRepository->getEmptyEntity();
        }

        $this->coreRegistry->register(
            ZoneModel::CURRENT_ZONE,
            $zone
        );
    }

    /**
     * Initiate action
     *
     * @return Zone
     */
    protected function _initAction()
    {
        $this->_view->loadLayout();

        return $this;
    }

    /**
     * Returns result of current user permission check on resource and privilege
     *
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('MageWorx_ShippingRules::zone');
    }
}
