<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingCalculatorBase\Plugin\ShippingRules;

use Magento\Quote\Model\Quote\Address as QuoteAddress;

/**
 * Class QuoteSubstitution
 */
class QuoteSubstitution
{
    /**
     * Is need to substitute a quote address for shipping rules
     *
     * @var bool
     */
    private $substitutionFlag = false;

    /**
     * @var QuoteAddress
     */
    private $address;

    /**
     * @param \MageWorx\ShippingRules\Model\Validator $subject
     * @param mixed ...$args
     * @return array
     */
    public function beforeValidate($subject, ...$args): array
    {
        if ($this->isSubstitutionNeeded()) {
            $address = $this->getAddress();
            $subject->setActualShippingAddress($address);
        }

        return $args;
    }

    /**
     * @param QuoteAddress $address
     * @return QuoteSubstitution
     */
    public function setAddress(QuoteAddress $address): QuoteSubstitution
    {
        $this->address = $address;

        return $this;
    }

    /**
     * @return QuoteAddress|null
     */
    public function getAddress(): ?QuoteAddress
    {
        return $this->address;
    }

    /**
     * Is need to change quote address during plugin processing
     *
     * @param bool $value
     * @return QuoteSubstitution
     */
    public function setSubstitutionFlag(bool $value = false): QuoteSubstitution
    {
        $this->substitutionFlag = $value;

        return $this;
    }

    /**
     * Is need to change quote address during plugin processing
     *
     * @return bool
     */
    public function isSubstitutionNeeded(): bool
    {
        return $this->substitutionFlag;
    }
}
