<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */
declare(strict_types = 1);

namespace MageWorx\OptionDependency\Test\Unit\Model;

use MageWorx\OptionDependency\Model\HiddenDependents;

/**
 * A testable subclass to expose protected methods.
 */
class TestableHiddenDependents extends HiddenDependents
{
    // Expose the protected method for testing.
    public function testProcessDependencyOrRules(array $dependencyRule): void
    {
        $this->processDependencyOrRules($dependencyRule);
    }

    public function getHiddenValues(): array
    {
        return $this->hiddenValues;
    }

    public function setSelectedValues(array $selectedValues): void
    {
        $this->selectedValues = $selectedValues;
    }

    public function setOptionToValuesMap(array $map): void
    {
        $this->optionToValuesMap = $map;
    }
}
