define(['jquery', 'underscore', 'jquery-ui-modules/widget', 'jquery/validate', 'mage/translate'], function ($, _) {
    'use strict';

    return function (config) {
        const msg = ' Step is ';
        let step = '';

        // Function to return error message for invalid step input
        const messager = () => $.mage.__(msg) + step;

        $.validator.addMethod("mageworx-dynamic-option-step-rule", function (value, element) {
            const name = element.name;
            const optionId = name.replace("options[", '').replace("]", '');

            // If option is not defined in config, skip validation
            if (_.isUndefined(config.config['options_data'][optionId])) {
                return true;
            }

            // If the field is hidden, skip validation
            const $container = $(element).closest('.field');
            if ($container.length > 0 && $container.css('display') === 'none') {
                return true;
            }

            // Get step value and convert to float
            step = parseFloat(config.config['options_data'][optionId]['step']);
            if (isNaN(step) || step <= 0) {
                return true;
            }

            // Convert value to float and calculate the multiplier based on decimal places
            const valueFloat = parseFloat(value);
            const multiplier = Math.pow(10, (step.toString().split('.')[1] || []).length); // Multiplier to handle floating-point precision

            // Check if the value is divisible by the step without remainder
            return Math.round(valueFloat * multiplier) % Math.round(step * multiplier) === 0;
        }, messager);
    };
});
