<?php
namespace Chilliapple\AutoStatus\Cron;

use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Sales\Model\OrderFactory;
use Magento\Framework\App\State;
use Psr\Log\LoggerInterface;

class AutoCancel
{
    protected $_transactionCollectionFactory;
    protected $orderRepository;
    protected $orderFactory;
    protected $logger;

    public function __construct(
        \Magenest\SagePay\Model\ResourceModel\Transaction\CollectionFactory $transactionCollectionFactory,
        OrderRepositoryInterface $orderRepository,
        OrderFactory $orderFactory,
        LoggerInterface $logger,
        State $state
    ) {
        $this->_transactionCollectionFactory = $transactionCollectionFactory;
        $this->orderRepository = $orderRepository;
        $this->orderFactory = $orderFactory;
        $this->logger = $logger;
        try {
            $state->setAreaCode('frontend');
        } catch (\Exception $e) {}
    }

    public function execute()
    {
        $this->logger->info("AutoCancel Cron Started");
        
        $date = new \DateTime();
        $date->modify('-1 hour');
        $oneHourAgo = $date->format('Y-m-d H:i:s');

        $transaction = $this->_transactionCollectionFactory->create()->addFieldToFilter('order_id', ['null' => true])->addFieldToFilter('created_at', ['lteq' => $oneHourAgo]);
        $this->logger->info("Count: ".count($transaction));
        foreach ($transaction as $trans) {
            try {
                $vendorTxCode = $trans->getVendorTxCode();
                $transactionId = $trans->getTransactionId();
                if ($vendorTxCode) {
                    $this->logger->info("vendorTxCode #{$vendorTxCode} before split.");
                    $parts = explode('-', $vendorTxCode);
                    $incrementId = isset($parts[2]) ? $parts[2] : null;
                    $this->logger->info("Increment #{$incrementId} before order load.");
                    $order = $this->orderFactory->create()->loadByIncrementId($incrementId);
                    if($order->getId()){
                        if ($order->canCancel()) {
                            $reason = "Order cancelled due to ".$trans->getTransactionStatus();
                            $order->cancel();
                            $order->addStatusHistoryComment(__('Order cancelled: %1', $reason))->setIsCustomerNotified(false);
                            $this->orderRepository->save($order);
                            $this->logger->info("Order #{$incrementId} of Trans Id #{$transactionId} cancelled successfully.");
                        } else {
                            $this->logger->info("Order #{$incrementId} of Trans Id #{$transactionId} may already be cancelled.");
                        }
                    }else{
                        $this->logger->info("Order #{$incrementId} not found of vendorTxCode #{$vendorTxCode} Trans Id #{$transactionId}.");
                    }
                }
            } catch (\Exception $e) {
                $this->logger->error("Exception: vendorTxCode #{$vendorTxCode} of Trans Id #{$transactionId}: " . $e->getMessage());
            }
            $this->logger->info("------------------");
        }
        $this->logger->info("AutoCancel Cron Finished");
    }

}