/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

define(['Magento_SalesRule/js/action/set-coupon-code'],function(couponCodeAction)
{
    'use strict';

	couponCodeAction.registerSuccessCallback(response => 
	{
		if ('undefined' !== typeof dataLayer)
		{
			dataLayer.push(
			{
				event: 			'applyCouponCode',
				eventCategory:	'Coupon',
				eventAction:	'Apply',
				eventLabel: 	window.coupon ? window.coupon : ''
			});
		}
	});

	couponCodeAction.registerFailCallback(response => 
	{
		if ('undefined' !== typeof dataLayer)
		{
			dataLayer.push(
			{
				event: 			'failCouponCode',
				eventCategory:	'Coupon',
				eventAction:	'Fail',
				eventLabel: 	window.coupon ? window.coupon : ''
			});
		}
	});

    return target => 
    {
        return target.extend(
        {
        	apply: function () 
        	{
				window.coupon = this.couponCode();
				
        		this._super();	
            },
            cancel: function () 
        	{
				window.coupon = this.couponCode();

        		if ('undefined' !== typeof dataLayer)
				{
					dataLayer.push(
					{
						event: 			'cancelCouponCode',
						eventCategory:	'Coupon',
						eventAction:	'Cancel',
						eventLabel: 	this.couponCode()
					});
				}
        		
        		this._super();	
            }
        });
    };
});