<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

declare(strict_types=1);

namespace Anowave\Ec\ViewModel;

use Anowave\Ec\Helper\Data;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Catalog\Block\Product\ListProduct;

class ProductList implements ArgumentInterface
{
    const EVENT = 'view_item_list';
    
    /**
     * @var \Anowave\Ec\Helper\Data
     */
    protected $helper;
    
    /**
     * @var Registry
     */
    protected $registry;

    /**
     * Constructor 
     * 
     * @param Data $helper
     * @param Registry $registry
     */
    public function __construct
    (
        Data $helper,
        Registry $registry
    )
    {
        /**
         * Set helper
         * 
         * @var Data $helper
         */
        $this->helper = $helper;
        
        /**
         * Set registry 
         * 
         * @var Registry $registry
         */
        $this->registry = $registry;
    }
    
    /**
     * Get impression payload default parameters 
     * 
     * @param ListProduct $block
     * @return string
     */
    public function getImpressionPayload(ListProduct $block) : string
    {
        try 
        {
            $category = $this->getCurrentCategory(); 
            
            $payload = 
            [
                'ecommerce' => 
                [
                    'item_list_id'   => $this->helper->getCategoryList($category),
                    'item_list_name' => $this->helper->getCategoryList($category),
                ],
                'event' => static::EVENT
            ];
        }
        catch (\Exception $e)
        {
            $payload = [];
        }
        
        return $this->helper->getJsonHelper()->encode($payload);
    }
    
    /**
     * Get Search impression payload 
     * 
     * @param ListProduct $block
     * @return string
     */
    public function getSearchImpressionPayload(ListProduct $block) : string
    {
        try
        {
            $payload =
            [
                'ecommerce' =>
                [
                    'item_list_id'   => __("Search results"),
                    'item_list_name' => __("Search results"),
                ],
                'event' => static::EVENT
            ];
        }
        catch (\Exception $e)
        {
            $payload = [];
        }
        
        return $this->helper->getJsonHelper()->encode($payload);
    }
    
   
    /**
     * Get current category 
     * 
     * @return mixed|NULL
     */
    public function getCurrentCategory()
    {
        return $this->registry->registry('current_category');
    }
    
    /**
     * Get current category
     *
     * @return mixed|NULL
     */
    public function getCurrentCategoryName() : string
    {
        return $this->helper->getJsonHelper()->encode
        (
            $this->getCurrentCategory()->getName()
        );
    }
}