<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Test\Unit\Helper;

use Anowave\Ec\Helper\Data;
use Magento\Framework\TestFramework\Unit\Helper\ObjectManager;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\Helper\Context;

class DataTest extends \PHPUnit\Framework\TestCase
{
	/**
     * @var StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var Context
     */
    protected $context;

	/**
	 * Setup 
	 * 
	 * {@inheritDoc}
	 * @see \PHPUnit\Framework\TestCase::setUp()
	 */
	protected function setUp() : void
	{
		$this->context = $this->createMock(Context::class);
		
        $this->storeManager = $this->getMockForAbstractClass(StoreManagerInterface::class);
	}

	public function testClass()
	{
		$this->storeManager->expects($this->any())->method('getStore')->willReturnSelf();
	}

	public function getHelper() 
	{
		return (new ObjectManager($this))->getObject(Data::class, 
		[
			'context' 		=> $this->context,
			'storeManager' 	=> $this->storeManager
		]);
	}
}