<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Plugin\Page;

use Anowave\Ec\Helper\Dom;
use Anowave\Ec\Helper\Data;
use Anowave\Ec\Model\Nonce;
use Anowave\Ec\Helper\Constants;

class Config
{
    /**
     * @var Dom
     */
    protected $dom;

    /**
     * @var Data
     */
    protected $helper;
    
    /**
     * @var Nonce
     */
    protected $nonce;
    
    /**
     * Constructor
     * 
     * @param Dom $dom
     */
    public function __construct
    (
        Dom $dom,
        Data $helper,
        Nonce $nonce
    )
    {
        $this->dom = $dom;
        $this->helper = $helper;
        $this->nonce = $nonce;
    }

    /**
     * Modify includes input 
     * 
     * @param \Magento\Framework\View\Page\Config $page
     * @param string $content
     * 
     * @return [type]
     */
    public function afterGetIncludes(\Magento\Framework\View\Page\Config $page, $content)
    {
        list($doc, $dom) = $this->dom->getDom();

        $dom->loadHTML((string) $content);

        if ($this->helper->supportCookieDirective())
        {
            if (0 < strlen(trim($content)))
            {
                $query = new \DOMXPath($dom);

                /**
                 * Array of flagged scripts
                 */
                $flag = [];

                foreach($query->query('//script') as $script)
                {
                    $script->setAttribute('type', Constants::SCRIPT_TYPE);


                    $attribute = (string) $script->getAttribute('data-consent');

                    if (0 === strlen(trim($attribute)))
                    {
                        $script->setAttribute('data-consent', Constants::COOKIE_CONSENT_GRANTED_EVENT);
                        $script->setAttribute('nonce', $this->nonce->generateNonce());
                    } 
                }

                
            }
        }

        if ($this->helper->supportPreconnect())
        {
            $head = null;

            foreach($dom->getElementsByTagName('head') as $tag)
            {
                $head = $tag;
            }
            
            if ($head)
            {
                foreach
                (
                    [
                        'https://www.googletagmanager.com',
                        'https://www.google-analytics.com'
                ] 
                as $resource)
                {
                    $link = $dom->createElement('link');
    
                    $link->setAttribute('rel','preconnect');
                    $link->setAttribute('href',$resource);
        
                    $head->prepend($link);
                }
            }           
        }
       
        return $this->dom->getDOMContent($dom, $doc);
    }
}