<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Model\TikTok;

use Anowave\Ec\Model\Api\TikTok\Api as AbstractApi;

class Api extends AbstractApi
{
    /** 
     * Track TikTok Server-side event 
     * 
     * @param string $event
     * @param array $params
     * 
     * @return array
     */
    public function track(string $event = 'InitiateCheckout', array $params = []) : array
    {
        return $this->curl->post(static::ENDPOINT,[]);
    }

    /**
     * Track initiate checkout 
     * 
     * @return array
     */
    public function trackInitateCheckout() : array
    {
        $params = $this->getParams
        (
            [
                "properties" => 
                [
                    "contents"=> 
                    [
                    
                        "price"=>  0,
                        "quantity" => 1,
                        "content_id" => "1077218",
                        "content_name" => "running shoes",
                        "content_category" => "Shoes > Sneakers > running shoes",
                        "brand" => "Anowave"
                    ]
                ],
                "content_type" => "product",
                
                "value" => 0
            ]
        );

        return $this->track('InitiateCheckout', $params);
    }
}