<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */
 
namespace Anowave\Ec\Block\Field;

use Magento\Framework\Data\Form\Element\AbstractElement;

use Anowave\Ec\Helper\Data;
use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field;

class Key extends Field
{
	/**
	 * @var Data
	 */
	protected $helper;


	/**
	 * Constructor 
	 * 
	 * @param Context $context
	 * @param Data $helper
	 * @param array $data
	 */
    public function __construct
    (
    	Context $context,
		Data $helper,
		
    	array $data = [])
    {
    	parent::__construct($context, $data);

		$this->helper = $helper;
		
    }
	
	/**
	 * Get element content
	 * 
	 * @see \Magento\Config\Block\System\Config\Form\Field::_getElementHtml()
	 */
	protected function _getElementHtml(AbstractElement $element)
	{
		if ($this->helper->getKey())
		{
			$key = $this->helper->getJsonKey();

			$json = json_decode(file_get_contents($key), true);

			if (array_key_exists('private_key', $json))
			{
				$json['private_key'] = str_pad('*', 10,'*');
			}

			if (array_key_exists('private_key_id', $json))
			{
				$json['private_key_id'] = str_pad('*', 10,'*');
			}
			
		}
		else
		{
			$json = json_encode([]);
		}

		return $this->getLayout()->createBlock('Anowave\Ec\Block\Comment')->setTemplate('key.phtml')->setData(['json' => $json])->toHtml();
	}
}