<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Knn;

use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class SearchModels extends AbstractEndpoint
{
    public function getURI(): string
    {
        return '/_plugins/_knn/models/_search';
    }

    public function getParamWhitelist(): array
    {
        return [
            '_source',
            '_source_excludes',
            '_source_includes',
            'allow_no_indices',
            'allow_partial_search_results',
            'analyze_wildcard',
            'analyzer',
            'batched_reduce_size',
            'ccs_minimize_roundtrips',
            'default_operator',
            'df',
            'docvalue_fields',
            'expand_wildcards',
            'explain',
            'from',
            'ignore_throttled',
            'ignore_unavailable',
            'lenient',
            'max_concurrent_shard_requests',
            'pre_filter_shard_size',
            'preference',
            'q',
            'request_cache',
            'rest_total_hits_as_int',
            'routing',
            'scroll',
            'search_type',
            'seq_no_primary_term',
            'size',
            'sort',
            'stats',
            'stored_fields',
            'suggest_field',
            'suggest_mode',
            'suggest_size',
            'suggest_text',
            'terminate_after',
            'timeout',
            'track_scores',
            'track_total_hits',
            'typed_keys',
            'version',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return isset($this->body) ? 'POST' : 'GET';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }
}
