<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Block\Adminhtml\Shippingrules\Quote\Edit\Tab;

use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Form\Renderer\Fieldset;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Framework\Data\Form;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Registry;
use Magento\Rule\Model\Condition\AbstractCondition;
use MageWorx\ShippingRules\Model\Rule;
use MageWorx\ShippingRules\Model\RuleFactory;

class Items extends Generic implements
    TabInterface
{
    /**
     * Core registry
     *
     * @var Fieldset
     */
    protected $rendererFieldset;

    /**
     * @var \Magento\Rule\Block\Actions
     */
    protected $actions;

    /**
     * @var RuleFactory
     */
    private $ruleFactory;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param FormFactory $formFactory
     * @param \Magento\Rule\Block\Actions $actions
     * @param Fieldset $rendererFieldset
     * @param array $data
     */
    public function __construct(
        Context                     $context,
        Registry                    $registry,
        FormFactory                 $formFactory,
        \Magento\Rule\Block\Actions $actions,
        RuleFactory                 $ruleFactory,
        Fieldset                    $rendererFieldset,
        array                       $data = []
    ) {
        $this->rendererFieldset = $rendererFieldset;
        $this->actions          = $actions;
        $this->ruleFactory      = $ruleFactory;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /** {@inheritdoc} */
    public function getTabLabel()
    {
        return __('Apply to Items');
    }

    /** {@inheritdoc} */
    public function getTabTitle()
    {
        return __('Apply to Items');
    }

    /** {@inheritdoc} */
    public function canShowTab()
    {
        return true;
    }

    /** {@inheritdoc} */
    public function isHidden()
    {
        return false;
    }

    /**
     * Prepare form before rendering HTML
     *
     * @return Generic
     */
    protected function _prepareForm()
    {
        /** @var Rule $model */
        $model = $this->_coreRegistry->registry('current_promo_quote_rule');

        if (!$model) {
            $id    = $this->getRequest()->getParam('id');
            $model = $this->ruleFactory->create();
            $model->load($id);
        }

        /** @var Form $form */
        $form = $this->_formFactory->create();
        $form->setHtmlIdPrefix('rule_');

        $renderer = $this->rendererFieldset->setTemplate(
            'Magento_CatalogRule::promo/fieldset.phtml'
        )->setNewChildUrl(
            $this->getUrl(
                'mageworx_shippingrules/shippingrules_quote/newActionHtml/form/rule_items_fieldset'
            )
        )->setNameInLayout(
            'items_fieldset'
        );

        $fieldset = $form->addFieldset(
            'items_fieldset',
            [
                'legend' => __(
                    'Apply the rule only to cart items matching the following conditions ' .
                    '(leave blank for all items).'
                )
            ]
        )->setRenderer(
            $renderer
        );

        $fieldset->addField(
            'items',
            'text',
            [
                'name'  => 'apply_to',
                'label' => __('Apply To'),
                'title' => __('Apply To')
            ]
        )->setRule(
            $model
        )->setRenderer(
            $this->actions
        );

        $form->setValues($model->getData());
        $this->setForm($form);

        return parent::_prepareForm();
    }

    /**
     * Handles addition of form name to action and its actions.
     *
     * @param AbstractCondition $actions
     * @param string $formName
     * @return void
     */
    private function setActionFormName(AbstractCondition $actions, $formName)
    {
        $actions->setFormName($formName);
        if ($actions->getActions() && is_array($actions->getActions())) {
            foreach ($actions->getActions() as $condition) {
                $this->setActionFormName($condition, $formName);
            }
        }
    }
}
