<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Plugin\Block\Widget;

class Tabs
{
    /**
     * Add after tab
     */
    const AFTER = 'customers';

    /**
     * Around add tab
     * 
     * @param \Magento\Backend\Block\Widget\Tabs $tabs
     * @param callable $proceed
     * @param mixed $tabId
     * @param mixed $tab
     * 
     * @return [type]
     */
    public function aroundAddTab(\Magento\Backend\Block\Widget\Tabs $tabs, callable $proceed, $tabId, $tab)
    {
        if (static::AFTER === $tabId)
        {
            $proceed('ec', 
            [
                'label' => __('Google Ads'),
                'url'   => $tabs->getUrl('track/analytics/ads', ['_current' => true]),
                'class' => 'ajax'
            ]);
        }
        
        return $proceed($tabId, $tab);
    }
}