<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Security;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class CreateActionGroup extends AbstractEndpoint
{
    protected $action_group;

    public function getURI(): string
    {
        if (!isset($this->action_group) || $this->action_group === '') {
            throw new RuntimeException('action_group is required for create_action_group');
        }
        $action_group = $this->action_group;

        return '/_plugins/_security/api/actiongroups/' . rawurlencode($action_group);
    }

    public function getParamWhitelist(): array
    {
        return [
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'PUT';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }

    public function setActionGroup($action_group): static
    {
        if (is_null($action_group)) {
            return $this;
        }
        $this->action_group = $action_group;

        return $this;
    }
}
