<?php
/**
 * @category    WeltPixel
 * @package     WeltPixel_LayeredNavigation
 * @copyright   Copyright (c) 2018 Weltpixel
 * @author      Weltpixel TEAM
 */

namespace WeltPixel\LayeredNavigation\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

/**
 * Class CategoryShowAs
 * @package WeltPixel\LayeredNavigation\Model\Config\Source
 */
class CategoryShowAs implements ArrayInterface
{
    /**
     * @var array
     */
    protected $_showAs = array(
        0 => 'Closed',
        1 => 'Fully Opened'
    );

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $options = array();
        foreach ($this->_showAs as $id => $showAs) :
            $options[] = array(
                'value' => $id,
                'label' => $showAs
            );
        endforeach;
        return $options;
    }
}
