<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Ui\DataProvider\Region\Form\Modifier;

use Magento\Framework\Registry;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Framework\UrlInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;
use MageWorx\ShippingRules\Model\Region;
use MageWorx\ShippingRules\Model\RegionFactory;

/**
 * Class AbstractModifier
 */
abstract class AbstractModifier implements ModifierInterface
{
    public const FORM_NAME           = 'mageworx_shippingrules_region_form';
    public const DATA_SOURCE_DEFAULT = 'region';
    public const DATA_SCOPE_METHOD   = 'data.region';

    /**
     * Container fieldset prefix
     */
    public const CONTAINER_PREFIX = 'container_';

    /**
     * Meta config path
     */
    public const META_CONFIG_PATH = '/arguments/data/config';

    /**
     * @var ArrayManager
     */
    protected $arrayManager;

    /**
     * @var UrlInterface
     */
    protected $urlBuilder;

    /**
     * @var RegionFactory
     */
    protected $regionFactory;

    /**
     * @var Registry
     */
    protected $registry;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param ArrayManager $arrayManager
     * @param UrlInterface $urlBuilder
     * @param RegionFactory $regionFactory
     * @param Registry $coreRegistry
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        ArrayManager          $arrayManager,
        UrlInterface          $urlBuilder,
        RegionFactory         $regionFactory,
        Registry              $coreRegistry,
        StoreManagerInterface $storeManager
    ) {
        $this->arrayManager  = $arrayManager;
        $this->urlBuilder    = $urlBuilder;
        $this->regionFactory = $regionFactory;
        $this->registry      = $coreRegistry;
        $this->storeManager  = $storeManager;
    }

    /**
     * Get current region or empty
     *
     * @return Region
     */
    protected function getRegion()
    {
        $rate = $this->registry->registry(Region::CURRENT_REGION);
        if (!$rate) {
            $rate = $this->regionFactory->create();
        }

        return $rate;
    }
}
