<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */
declare(strict_types = 1);

namespace MageWorx\ShippingRules\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Framework\ObjectManagerInterface;
use MageWorx\ShippingRules\Api\SourceModelFactoryInterface;

/**
 * Create source models dynamically
 */
class SourceModelFactory implements SourceModelFactoryInterface
{
    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * @param ObjectManagerInterface $objectManager
     */
    public function __construct(
        ObjectManagerInterface $objectManager
    ) {
        $this->objectManager = $objectManager;
    }

    /**
     * @inheritDoc
     */
    public function create(string $className, ...$arguments): OptionSourceInterface
    {
        return $this->objectManager->create($className, $arguments);
    }
}
