<?php
namespace BG\DesignHuddle\Model\Checkout;

use Magento\Quote\Model\ResourceModel\Quote\CollectionFactory;

class Session extends \Magento\Checkout\Model\Session
{

    /**
     * @param \Magento\Framework\App\Request\Http
     * @param \Magento\Framework\Session\SidResolverInterface
     * @param \Magento\Framework\Session\Config\ConfigInterface
     * @param \Magento\Framework\Session\SaveHandlerInterface
     * @param \Magento\Framework\Session\ValidatorInterface
     * @param \Magento\Framework\Session\StorageInterface
     * @param \Magento\Framework\Stdlib\CookieManagerInterface
     * @param \Magento\Framework\Stdlib\Cookie\CookieMetadataFactory
     * @param \Magento\Framework\App\State
     * @param \Magento\Sales\Model\OrderFactory
     * @param \Magento\Customer\Model\Session
     * @param \Magento\Quote\Api\CartRepositoryInterface
     * @param \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress
     * @param \Magento\Framework\Event\ManagerInterface
     * @param \Magento\Store\Model\StoreManagerInterface
     * @param \Magento\Customer\Api\CustomerRepositoryInterface
     * @param QuoteIdMaskFactory
     * @param \Magento\Quote\Model\QuoteFactory
     * @param \Magento\Quote\Model\ResourceModel\Quote\CollectionFactory
     */

    protected $_resource;

    private CollectionFactory $quoteCollectionFactory;

    public function __construct(
        \Magento\Framework\App\Request\Http $request,
        \Magento\Framework\Session\SidResolverInterface $sidResolver,
        \Magento\Framework\Session\Config\ConfigInterface $sessionConfig,
        \Magento\Framework\Session\SaveHandlerInterface $saveHandler,
        \Magento\Framework\Session\ValidatorInterface $validator,
        \Magento\Framework\Session\StorageInterface $storage,
        \Magento\Framework\Stdlib\CookieManagerInterface $cookieManager,
        \Magento\Framework\Stdlib\Cookie\CookieMetadataFactory $cookieMetadataFactory,
        \Magento\Framework\App\State $appState,
        \Magento\Sales\Model\OrderFactory $orderFactory,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Quote\Api\CartRepositoryInterface $quoteRepository,
        \Magento\Framework\HTTP\PhpEnvironment\RemoteAddress $remoteAddress,
        \Magento\Framework\Event\ManagerInterface $eventManager,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository,
        \Magento\Quote\Model\QuoteIdMaskFactory $quoteIdMaskFactory,
        \Magento\Quote\Model\QuoteFactory $quoteFactory,
        \Magento\Quote\Model\ResourceModel\Quote\CollectionFactory $quoteCollectionFactory,
        \Magento\Framework\App\ResourceConnection $resource)
    {
        parent::__construct(
            $request,
            $sidResolver,
            $sessionConfig,
            $saveHandler,
            $validator,
            $storage,
            $cookieManager,
            $cookieMetadataFactory,
            $appState,
            $orderFactory,
            $customerSession,
            $quoteRepository,
            $remoteAddress,
            $eventManager,
            $storeManager,
            $customerRepository,
            $quoteIdMaskFactory,
            $quoteFactory
        );
        $this->_resource = $resource;
        $this->quoteCollectionFactory = $quoteCollectionFactory;
    }
    public function loadCustomerQuote()
    {
        /* $writer = new \Zend_Log_Writer_Stream(BP . '/var/log/BG_NEWSession1145.log');
        $logger = new \Zend_Log();
        $logger->addWriter($writer);
        $logger->info("NEW123_First=>".$this->getQuoteId()); // OLD QUOTE DONE
  */
        if (!$this->_customerSession->getCustomerId() || is_null($this->getQuote()->getGrandTotal())) {
            return $this;
        }
        $this->_eventManager->dispatch('load_customer_quote_before', ['checkout_session' => $this]);
        try {
            $customerQuote = $this->quoteRepository->getForCustomer($this->_customerSession->getCustomerId());
        } catch (NoSuchEntityException $e) {
            $customerQuote = $this->quoteFactory->create();
        }
        $customerQuote->setStoreId($this->_storeManager->getStore()->getId());

        if ($customerQuote->getId() && $this->getQuoteId() != $customerQuote->getId()) {
            if ($this->getQuoteId()) {
                $quote = $this->getQuote();
                $quote->setCustomerIsGuest(0);
                $this->quoteRepository->save(
                    $customerQuote->merge($quote)->collectTotals()
                );
                $newQuote = $this->quoteRepository->get($customerQuote->getId());
                $this->quoteRepository->save(
                    $newQuote->collectTotals()
                );
                $customerQuote = $newQuote;
            }
           // $logger->info("CustomerId()=>".$this->_customerSession->getCustomerId()); // OLD QUOTE DONE

            $connection = $this->_resource->getConnection(\Magento\Framework\App\ResourceConnection::DEFAULT_CONNECTION);
            $tableName = $connection->getTableName('design_huddle_custom_design_data');
            $sql = "UPDATE " . $tableName . " Set `quote_id` ='".$customerQuote->getId()."', `customer_id` ='".$this->_customerSession->getCustomerId()."' where `quote_id` = '".$this->getQuoteId()."'";
            $connection->query($sql);

            $this->setQuoteId($customerQuote->getId());

            if ($this->_quote) {
                $this->quoteRepository->delete($this->_quote);
            }
            $this->_quote = $customerQuote;

        } else {
            $this->getQuote()->getBillingAddress();
            $this->getQuote()->getShippingAddress();
            $this->getQuote()->setCustomer($this->_customerSession->getCustomerDataObject())
                ->setCustomerIsGuest(0)
                ->setTotalsCollectedFlag(false)
                ->collectTotals();
            $this->quoteRepository->save($this->getQuote());
        }
        return $this;
    }
}
?>
