<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\Downloads\Model\ResourceModel\Attachment\Grid;

use MageWorx\Downloads\Model\ResourceModel\Attachment;
use MageWorx\Downloads\Model\ResourceModel\Attachment\Collection as AttachmentCollection;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Data\Collection\EntityFactoryInterface;
use Psr\Log\LoggerInterface;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface;
use Magento\Framework\Event\ManagerInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Store\Model\StoreManagerInterface;
use MageWorx\Downloads\Helper\Data as HelperData;

class Collection extends AttachmentCollection implements SearchResultInterface
{
    /**
     * Aggregations
     *
     * @var \Magento\Framework\Search\AggregationInterface
     */
    protected $aggregations;

    /**
     * Constructor
     *
     * @param \Magento\Framework\Data\Collection\EntityFactoryInterface $entityFactory
     * @param \Psr\Log\LoggerInterface $logger
     * @param \Magento\Framework\Data\Collection\Db\FetchStrategyInterface $fetchStrategy
     * @param \Magento\Framework\Event\ManagerInterface $eventManager
     * @param StoreManagerInterface $storeManager
     * @param HelperData $helperData
     * @param $mainTable
     * @param $eventPrefix
     * @param $eventObject
     * @param $resourceModel
     * @param string $model
     * @param null $connection
     * @param AbstractDb|null $resource
     */
    public function __construct(
        EntityFactoryInterface $entityFactory,
        LoggerInterface $logger,
        FetchStrategyInterface $fetchStrategy,
        ManagerInterface $eventManager,
        StoreManagerInterface $storeManager,
        HelperData $helperData,
        $mainTable,
        $eventPrefix,
        $eventObject,
        $resourceModel,
        $model = \Magento\Framework\View\Element\UiComponent\DataProvider\Document::class,
        $connection = null,
        ?AbstractDb $resource = null
    ) {
        parent::__construct(
            $entityFactory,
            $logger,
            $fetchStrategy,
            $eventManager,
            $storeManager,
            $helperData,
            $connection,
            $resource
        );
        $this->_eventPrefix = $eventPrefix;
        $this->_eventObject = $eventObject;
        $this->_init($model, $resourceModel);
        $this->setMainTable($mainTable);
    }

    /**
     *
     * @return \MageWorx\Downloads\Model\ResourceModel\Attachment\Collection
     */
    protected function _initSelect()
    {
        parent::_initSelect();
        $this->joinProduct()->getSelect()
             ->columns(
                 ['products_count' => 'COUNT(product_relation_table.attachment_id)']
             )
             ->group('main_table.attachment_id');

        return $this;
    }

    /**
     * @return \Magento\Framework\Search\AggregationInterface
     */
    public function getAggregations()
    {
        return $this->aggregations;
    }

    /**
     * @param \Magento\Framework\Search\AggregationInterface $aggregations
     * @return $this
     */
    public function setAggregations($aggregations)
    {
        $this->aggregations = $aggregations;

        return $this;
    }

    /**
     * Get search criteria.
     *
     * @return \Magento\Framework\Api\SearchCriteriaInterface|null
     */
    public function getSearchCriteria()
    {
        return null;
    }

    /**
     * Set search criteria.
     *
     * @param SearchCriteriaInterface|null $searchCriteria
     * @return $this
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function setSearchCriteria(?SearchCriteriaInterface $searchCriteria = null)
    {
        return $this;
    }

    /**
     * Get total count.
     *
     * @return int
     */
    public function getTotalCount()
    {
        return $this->getSize();
    }

    /**
     * Set total count.
     *
     * @param int $totalCount
     * @return $this
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function setTotalCount($totalCount)
    {
        return $this;
    }

    /**
     * Set items list.
     *
     * @param \Magento\Framework\Api\ExtensibleDataInterface[]|null $items
     * @return $this
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function setItems(?array $items = null)
    {
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    protected function _renderFiltersBefore()
    {
        $this->addLocales(\Magento\Store\Model\Store::DEFAULT_STORE_ID);
        parent::_renderFiltersBefore();
    }

    /**
     * @return $this
     */
    protected function _afterLoad()
    {
        $this->loadStoreRelation();

        return parent::_afterLoad();
    }

    /**
     * load user relation
     */
    protected function loadStoreRelation()
    {
        $ids = $this->getColumnValues('attachment_id');
        if (count($ids)) {
            $data       = [];
            $connection = $this->getConnection();
            $select     = $connection->select()->from(
                [
                    'relation_store' => $this->getTable(Attachment::STORE_RELATION_TABLE)
                ]
            )->where('relation_store.attachment_id IN (?)', $ids);

            $relationResult = $connection->fetchAll($select);
            if ($relationResult) {
                $data = [];
                foreach ($relationResult as $storeData) {
                    $id                       = $storeData['attachment_id'];
                    $data[$id]['store_ids'][] = $storeData['store_id'];
                }
            }
            foreach ($this as $item) {
                $linkedId = $item->getData('attachment_id');
                if (!empty($data[$linkedId])) {
                    $item->setStoreIds($data[$linkedId]['store_ids']);
                } else {
                    $item->setStoreIds([]);
                }
            }
        }
    }
}
