/*jshint browser:true jquery:true*/
/*global alert*/
define([
    'jquery',
    'uiComponent',
    'ko'
], function ($, Component, ko) {
    'use strict';

    return Component.extend({
        defaults: {
            title: '',
            price_formatted: '',
            description: '',
            image: '',
            delivery_formatted: '',
            price: 0,
            imports: {
                cheapestPrice: 'shipping-calculator.methods-list:cheapestPrice',
                displayCheapestPrice: 'shipping-calculator.methods-list:displayCheapestPrice'
            }
        },

        /**
         * Properties which will be set as an observable during initObservable method call
         */
        observableProperties: [
            'title',
            'price_formatted',
            'description',
            'image',
            'delivery_formatted',
            'price',
            'cheapestPrice',
            'displayCheapestPrice'
        ],

        initialize: function () {
            this._super();
        },

        /**
         * Initialize observables properties
         *
         * @returns {exports}
         */
        initObservable: function () {
            this._super();
            this.observe(this.observableProperties);

            return this;
        }
    });
});
