/**
 * Copyright © MageWorx, Inc. All rights reserved.
 * See LICENSE.txt for license details.
 */
define([
    'underscore',
    'uiRegistry',
    'Magento_Ui/js/form/element/abstract'
], function (_, registry, Input) {
    'use strict';

    return Input.extend({
        defaults: {
            skipValidation: false,
            visible: false
        },

        /**
         * Properties which will be set as an observable during initObservable method call
         */
        observableProperties: [
            'additionalClasses',
            'invisible'
        ],

        /**
         * Initialize observables properties
         *
         * @returns {exports}
         */
        initObservable: function () {
            this._super();
            this.observe(this.observableProperties);
            this.visible.subscribe(function (value) {
                if (value && this.disabled()) {
                    this.visible(false);
                }
            }.bind(this));

            return this;
        },

        setVisible: function (value) {
            value = value && !this.disabled();
            this._super(value);
        },

        /**
         * Validates itself by it's validation rules using validator object.
         * If validation of a rule did not pass, writes it's message to
         * 'error' observable property.
         *
         * @returns {Object} Validate information.
         */
        validate: function () {
            return this._super();
        }
    });
});
