<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\DeliveryDate\Block;

use Magento\Checkout\Block\Checkout\LayoutProcessorInterface;

class OnepageLayoutModifications implements LayoutProcessorInterface
{
    /**
     * @var \MageWorx\DeliveryDate\Helper\Data
     */
    private $helper;

    /**
     * OnepageLayoutModifications constructor.
     *
     * @param \MageWorx\DeliveryDate\Helper\Data $helper
     */
    public function __construct(
        \MageWorx\DeliveryDate\Helper\Data $helper
    ) {
        $this->helper = $helper;
    }

    /**
     * Process js Layout of block
     *
     * @param array $jsLayout
     * @return array
     */
    public function process($jsLayout)
    {
        if (!$this->helper->isEnabled()) {
            unset($jsLayout["components"]["checkout"]["children"]["steps"]["children"]["shipping-step"]["children"]
                ["shippingAddress"]["children"]["shippingAdditional"]["children"]["delivery_date"]);
            unset($jsLayout["components"]["checkout"]["children"]["steps"]["children"]["store-pickup"]["children"]
                ["store-selector"]["children"]["delivery_date"]);

            return $jsLayout;
        }

        if (isset(
            $jsLayout["components"]["checkout"]["children"]["steps"]["children"]["shipping-step"]["children"]
            ["shippingAddress"]["children"]["shippingAdditional"]["children"]["delivery_date"]["children"]
        )
        ) {
            $parentSection = &$jsLayout["components"]["checkout"]["children"]["steps"]["children"]["shipping-step"]
            ["children"]["shippingAddress"]["children"]["shippingAdditional"]["children"]["delivery_date"]["children"];
        } else {
            return $jsLayout;
        }

        $dayComponent  = $parentSection["datetime_container"]["children"]["delivery_day"] ?? [];
        $timeComponent = $parentSection["datetime_container"]["children"]["delivery_time"] ?? [];
        $comment       = $parentSection["comment_container"]["children"]["delivery_comment"] ?? [];

        $parentSection["datetime_container"]["children"]["delivery_day"]    =
            $this->modifyDayComponent($dayComponent);
        $parentSection["datetime_container"]["children"]["delivery_time"]   =
            $this->modifyTimeComponent($timeComponent);
        $parentSection["comment_container"]["children"]["delivery_comment"] =
            $this->modifyCommentComponent($comment);

        // Magestore checkout compatibility
        if (isset($jsLayout["components"]["checkout"]["children"]["delivery-date"])) {
            $jsLayout["components"]["checkout"]["children"]["delivery-date"] = $jsLayout["components"]["checkout"]
            ["children"]["steps"]["children"]["shipping-step"]["children"]["shippingAddress"]["children"]
            ["shippingAdditional"]["children"]["delivery_date"];
            $jsLayout["components"]["checkout"]["children"]["delivery-date"]["displayArea"] = 'delivery-date';
            unset($jsLayout["components"]["checkout"]["children"]["steps"]["children"]["shipping-step"]["children"]
                ["shippingAddress"]["children"]["shippingAdditional"]["children"]["delivery_date"]);
        }

        return $jsLayout;
    }

    /**
     * @param array $dayComponent
     * @return array
     */
    private function modifyDayComponent($dayComponent)
    {
        $dayComponentData                       = $this->helper->getTemplateDataForDeliveryDateInput();
        $dayComponentData['defaultValueWasSet'] = !$this->helper->isPreSelectDeliveryDateEnabled();
        if ($this->helper->isDeliveryDateRequired()) {
            $dayComponent['validation']['required-entry'] = true;
            $dayComponent['caption']                      = null;
        } else {
            $dayComponent['caption'] = __('Select Delivery Date');
        }

        if ($this->helper->isPreSelectDeliveryDateEnabled()) {
            $dayComponent['defaultValueWasSet'] = false;
        } else {
            $dayComponent['defaultValueWasSet'] = true;
        }

        if ($this->helper->getDeliveryDateTitle()) {
            $dayComponent['labelVisible'] = true;
            $dayComponent['label']        = $this->helper->getDeliveryDateTitle();
        } else {
            $dayComponent['labelVisible'] = false;
        }

        $this->mergeComponents($dayComponent, $dayComponentData);

        return $dayComponent;
    }

    /**
     * @param array $timeComponent
     * @return array
     */
    private function modifyTimeComponent($timeComponent)
    {
        $timeComponentData = $this->helper->getTemplateDataForDeliveryTimeInput();
        if ($this->helper->isDeliveryDateRequired()) {
            $timeComponentData['validation']['required-entry'] = true;
        }

        if ($this->helper->getDeliveryTimeTitle()) {
            $timeComponent['labelVisible'] = true;
            $timeComponent['label']        = $this->helper->getDeliveryTimeTitle();
        } else {
            $timeComponent['labelVisible'] = false;
        }

        $this->mergeComponents($timeComponent, $timeComponentData);

        return $timeComponent;
    }

    /**
     * @param array $commentComponent
     * @return array
     */
    private function modifyCommentComponent($commentComponent)
    {
        $commentComponentData = [];

        if ($this->helper->getCommentFieldLabel()) {
            $commentComponentData['label'] = $this->helper->getCommentFieldLabel();
        }

        $this->mergeComponents($commentComponent, $commentComponentData);

        return $commentComponent;
    }

    /**
     * Merge two components definition (override component)
     *
     * @param array $arr1
     * @param array $arr2
     */
    private function mergeComponents(&$arr1, $arr2)
    {
        foreach ($arr1 as $key => $value) {
            if (empty($arr2[$key])) {
                continue;
            }

            if (!is_array($arr1[$key]) && !is_array($arr2[$key])) {
                // NOT Array and NOT Array
                $arr1[$key] = $arr2[$key];
            } elseif (is_array($arr1[$key]) && !is_array($arr2[$key])) {
                // Array and NOT Array
                $arr1[$key][] = $arr2[$key];
            } elseif (!is_array($arr1[$key]) && is_array($arr2[$key])) {
                // NOT Array and Array
                $temp       = $arr1[$key];
                $arr1[$key] = [$temp] + $arr2[$key];
            } else {
                // Array and Array
                $this->mergeComponents($arr1[$key], $arr2[$key]);
            }
        }
    }
}
