<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Endpoints\Notifications\CreateConfig;
use OpenSearch\Endpoints\Notifications\DeleteConfig;
use OpenSearch\Endpoints\Notifications\DeleteConfigs;
use OpenSearch\Endpoints\Notifications\GetConfig;
use OpenSearch\Endpoints\Notifications\GetConfigs;
use OpenSearch\Endpoints\Notifications\ListChannels;
use OpenSearch\Endpoints\Notifications\ListFeatures;
use OpenSearch\Endpoints\Notifications\SendTest;
use OpenSearch\Endpoints\Notifications\UpdateConfig;

/**
 * Class NotificationsNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class NotificationsNamespace extends AbstractNamespace
{
    /**
     * Create channel configuration.
     *
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createConfig(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(CreateConfig::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * Delete a channel configuration.
     *
     * $params['config_id']   = (string) The ID of the channel configuration to delete.
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteConfig(array $params = [])
    {
        $config_id = $this->extractArgument($params, 'config_id');

        $endpoint = $this->endpointFactory->getEndpoint(DeleteConfig::class);
        $endpoint->setParams($params);
        $endpoint->setConfigId($config_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Delete multiple channel configurations.
     *
     * $params['config_id']      = (string) The ID of the channel configuration to delete.
     * $params['config_id_list'] = (string) A comma-separated list of channel IDs to delete.
     * $params['pretty']         = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']          = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']    = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']         = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']    = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteConfigs(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(DeleteConfigs::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Get a specific channel configuration.
     *
     * $params['config_id']   = (string)
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getConfig(array $params = [])
    {
        $config_id = $this->extractArgument($params, 'config_id');

        $endpoint = $this->endpointFactory->getEndpoint(GetConfig::class);
        $endpoint->setParams($params);
        $endpoint->setConfigId($config_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Get multiple channel configurations with filtering.
     *
     * $params['chime.url']                                    = (string)
     * $params['chime.url.keyword']                            = (string)
     * $params['config_id']                                    = (string) Notification configuration ID.
     * $params['config_id_list']                               = (array) Notification configuration IDs.
     * $params['config_type']                                  = (enum) Type of notification configuration. (Options = chime,email,email_group,microsoft_teams,ses_account,slack,smtp_account,sns,webhook)
     * $params['created_time_ms']                              = (integer)
     * $params['description']                                  = (string)
     * $params['description.keyword']                          = (string)
     * $params['email.email_account_id']                       = (string)
     * $params['email.email_group_id_list']                    = (string)
     * $params['email.recipient_list.recipient']               = (string)
     * $params['email.recipient_list.recipient.keyword']       = (string)
     * $params['email_group.recipient_list.recipient']         = (string)
     * $params['email_group.recipient_list.recipient.keyword'] = (string)
     * $params['is_enabled']                                   = (boolean)
     * $params['last_updated_time_ms']                         = (integer)
     * $params['microsoft_teams.url']                          = (string)
     * $params['microsoft_teams.url.keyword']                  = (string)
     * $params['name']                                         = (string)
     * $params['name.keyword']                                 = (string)
     * $params['query']                                        = (string)
     * $params['ses_account.from_address']                     = (string)
     * $params['ses_account.from_address.keyword']             = (string)
     * $params['ses_account.region']                           = (string)
     * $params['ses_account.role_arn']                         = (string)
     * $params['ses_account.role_arn.keyword']                 = (string)
     * $params['slack.url']                                    = (string)
     * $params['slack.url.keyword']                            = (string)
     * $params['smtp_account.from_address']                    = (string)
     * $params['smtp_account.from_address.keyword']            = (string)
     * $params['smtp_account.host']                            = (string)
     * $params['smtp_account.host.keyword']                    = (string)
     * $params['smtp_account.method']                          = (string)
     * $params['sns.role_arn']                                 = (string)
     * $params['sns.role_arn.keyword']                         = (string)
     * $params['sns.topic_arn']                                = (string)
     * $params['sns.topic_arn.keyword']                        = (string)
     * $params['text_query']                                   = (string)
     * $params['webhook.url']                                  = (string)
     * $params['webhook.url.keyword']                          = (string)
     * $params['pretty']                                       = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']                                        = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace']                                  = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']                                       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']                                  = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getConfigs(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(GetConfigs::class);
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

    /**
     * List created notification channels.
     *
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function listChannels(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(ListChannels::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * List supported channel configurations.
     *
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function listFeatures(array $params = [])
    {
        $endpoint = $this->endpointFactory->getEndpoint(ListFeatures::class);
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }

    /**
     * Send a test notification.
     *
     * $params['config_id']   = (string)
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function sendTest(array $params = [])
    {
        $config_id = $this->extractArgument($params, 'config_id');

        $endpoint = $this->endpointFactory->getEndpoint(SendTest::class);
        $endpoint->setParams($params);
        $endpoint->setConfigId($config_id);

        return $this->performRequest($endpoint);
    }

    /**
     * Update channel configuration.
     *
     * $params['config_id']   = (string)
     * $params['pretty']      = (boolean) Whether to pretty-format the returned JSON response. (Default = false)
     * $params['human']       = (boolean) Whether to return human-readable values for statistics. (Default = false)
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors. (Default = false)
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) A comma-separated list of filters used to filter the response. Use wildcards to match any field or part of a field's name. To exclude fields, use `-`.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function updateConfig(array $params = [])
    {
        $config_id = $this->extractArgument($params, 'config_id');
        $body = $this->extractArgument($params, 'body');

        $endpoint = $this->endpointFactory->getEndpoint(UpdateConfig::class);
        $endpoint->setParams($params);
        $endpoint->setConfigId($config_id);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }

}
