<?php
/**
 * Mageplaza
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the mageplaza.com license that is
 * available through the world-wide-web at this URL:
 * https://www.mageplaza.com/LICENSE.txt
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category    Mageplaza
 * @package     Mageplaza_EmailAttachments
 * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)
 * @license     https://www.mageplaza.com/LICENSE.txt
 */

declare(strict_types=1);

namespace Mageplaza\CustomForm\Mail;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Mail\EmailMessageInterface;
use Magento\Email\Model\Transport as MailTransport;
use Psr\Log\LoggerInterface;

/**
 * Class Transport
 * @package Mageplaza\CustomForm\Mail
 */
class Transport extends MailTransport
{

    /**
     * @param EmailMessageInterface $message
     * @param ScopeConfigInterface $scopeConfig
     * @param LoggerInterface|null $logger
     */
    public function __construct(
        EmailMessageInterface $message,
        ScopeConfigInterface $scopeConfig,
        ?LoggerInterface $logger = null
    ) {
        parent::__construct($message, $scopeConfig, $logger);
    }

    /**
     * @inheritdoc
     */
    public function sendMessage(): void
    {
        parent::sendMessage();
    }
}
