<?php
/**
 * Magento 2 AI-Powered Smart Pricing & Competitor Monitoring
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * http://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Monitor
 * @copyright 	Copyright (c) 2025 Anowave (http://www.anowave.com/)
 * @license  	http://www.anowave.com/license-agreement/
 */
 
namespace Anowave\Ec\Cron;

use Psr\Log\LoggerInterface;

use Anowave\Ec\Model\Ads;
use Magento\Framework\App\ResourceConnection;
use Anowave\Ec\Model\QueueFactory;
use Anowave\Ec\Model\QueueRepository;
use Anowave\Ec\Helper\Constants;

class Batch 
{
	/**
	 * @var LoggerInterface
	 */
	protected $logger;

	/**
	 * @var ResourceConnection
	 */
	protected $resourceConnection;

	/**
	 * @var Ads
	 */
	protected $ads;

	/**
	 * @var QueueFactory
	 */
	protected $queueFactory;

	/**
	 * @var QueueRepository
	 */
	protected $queueRepository;

	
	private $connection = null;
	
	/**
	 * Constructor 
	 * 
	 * @param LoggerInterface $logger
	 */
	public function __construct
	(
		LoggerInterface $logger,
		ResourceConnection $resourceConnection,
		Ads $ads,
		QueueFactory $queueFactory,
		QueueRepository $queueRepository
	)
	{
		$this->logger = $logger;
		$this->resourceConnection = $resourceConnection;
		$this->ads = $ads;
		$this->queueFactory = $queueFactory;
		$this->queueRepository = $queueRepository;
	}

	/**
	 * Execute cron
	 * 
	 * @return void
	 */
	public function execute() 
	{
		try 
		{
			foreach($this->getBatch() as $batch)
			{
				$this->ads->enhance($batch['queue_order_id']);

				$queue = $this->queueRepository->getById($batch['queue_id']);

				$queue->setQueueStatusId(Constants::ADS_QUEUE_STATUS_ENHANCE);
				$queue->setQueueUpdatedAt(date('Y-m-d H:i:s'));

				$this->queueRepository->save($queue);
			}
		}
		catch (\Exception $e)
		{
			$this->logger->error($e->getMessage());	
		}
		
		return true;
	}

	/**
	 * Get urls 
	 * 
	 * @return array
	 */
	private function getBatch() : array 
	{
		$select = $this->getConnection()->select()->from
		(
			['queue' => $this->resourceConnection->getTableName('ae_ec_ads_queue')],['queue_id','queue_order_id']
		)
		->where('queue.queue_status_id = ' . Constants::ADS_QUEUE_STATUS_PENDING);

		$batch = $this->getConnection()->fetchAll($select);

		return $batch;
	}
	
	private function getConnection()
	{
		if (!$this->connection)
		{
			$this->connection = $this->resourceConnection->getConnection();
		}

		return $this->connection;
	}
}