<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Controller\Adminhtml\Ads;

use Magento\Backend\App\Action\Context;
use Magento\Backend\App\Action;
use Magento\Framework\Controller\Result\JsonFactory;
use Anowave\Ec\Cron\Batch;

class Cron extends Action
{
    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    protected $jsonFactory;

    /**
     * @var Batch
     */
    protected $batch;

    /**
     * Constructor 
     * 
     * @param Context $context
     * @param JsonFactory $jsonFactory
     */
    public function __construct
    (
        Context $context,
        JsonFactory $jsonFactory,
        Batch $batch
    ) 
    {
        parent::__construct($context);

        $this->batch = $batch;
        $this->jsonFactory = $jsonFactory;
    }
    
	public function execute()
	{
	    $resultJson = $this->jsonFactory->create();

        $this->batch->execute();

	    return $resultJson->setData(
        [
            'result' => true
        ]);
	}
}