<?php

namespace Xigen\CheckOrders\Console\Command;

use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Sales\Api\OrderRepositoryInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Magento\Sales\Api\Data\OrderInterface;

class CheckOrders extends Command
{

    const INCREMENT_ID = 'increment-id';

    private OrderRepositoryInterface $orderRepository;
    private SearchCriteriaBuilder $searchCriteriaBuilder;

    public function __construct(
        SearchCriteriaBuilder $searchCriteriaBuilder,
        OrderRepositoryInterface $orderRepository
    ) {
        $this->orderRepository = $orderRepository;
        parent::__construct();
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }


    /**
     * @inheritdoc
     */
    protected function configure()
    {
        $this->setName('xigen:check-orders')
            ->setDescription('Check that Design Hub information is attached to an order')
            ->addArgument(self::INCREMENT_ID,
                InputArgument::REQUIRED,
                'Increment ID/ Order Number');

    }

    public function execute(InputInterface $input, OutputInterface $output)
    {
        $incrementId = (string) $input->getArgument(self::INCREMENT_ID);
        $output->writeln("Order loaded using API (get List)");

        $this->searchCriteriaBuilder->addFilter(OrderInterface::INCREMENT_ID, $incrementId)->setPageSize(1);
        $orders = $this->orderRepository->getList($this->searchCriteriaBuilder->create())->getItems();

        foreach ($orders as $order) {
            $output->writeln("===================================");
            $output->writeln("Order: ".$order->getIncrementId());
            $output->writeln("===================================");
            foreach ($order->getAllItems() as $item) {
                $output->writeln("Item: ".$item->getId());
                $output->writeln("Sku: ".$item->getSku());
                $output->writeln("Design ID: ".$item->getExtensionAttributes()->getDesignId());
                $output->writeln("----------------------------------");
            }
        }

        exit;
    }


}
