<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Controller\Adminhtml;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Response\Http\FileFactory;
use MageWorx\ShippingRules\Api\ExportHandlerInterfaceFactory;
use MageWorx\ShippingRules\Api\ImportHandlerInterfaceFactory;

/**
 * Class ImportExport
 */
abstract class ImportExport extends Action
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
    public const ADMIN_RESOURCE = 'MageWorx_ShippingRules::import_export';

    /**
     * Menu id
     */
    public const MENU_IDENTIFIER = 'MageWorx_ShippingRules::system_import_export';

    /**
     * @var FileFactory
     */
    protected $fileFactory;

    /**
     * @var ExportHandlerInterfaceFactory
     */
    protected $exportHandlerFactory;

    /**
     * @var ImportHandlerInterfaceFactory
     */
    protected $importHandlerFactory;

    /**
     * @param Context $context
     * @param FileFactory $fileFactory
     * @param ExportHandlerInterfaceFactory $exportHandlerFactory
     * @param ImportHandlerInterfaceFactory $importHandlerFactory
     */
    public function __construct(
        Context                       $context,
        FileFactory                   $fileFactory,
        ExportHandlerInterfaceFactory $exportHandlerFactory,
        ImportHandlerInterfaceFactory $importHandlerFactory
    ) {
        $this->fileFactory          = $fileFactory;
        $this->exportHandlerFactory = $exportHandlerFactory;
        $this->importHandlerFactory = $importHandlerFactory;
        parent::__construct($context);
    }
}
