/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

define(['mage/utils/wrapper'], function (wrapper) 
{
    'use strict';

    return function (placeOrderAction) 
    {
        return wrapper.wrap(placeOrderAction, function (originalAction, paymentData, messageContainer) 
        {
        	if 
			(
			   'undefined' !== typeof AEC 
			&& 'undefined' !== typeof AEC.Checkout.getData() 
			&& 'undefined' !== typeof AEC.Const 
			&& 'undefined' !== typeof AEC.Const.CHECKOUT_STEP_ORDER
			&& 'undefined' !== typeof AEC.Checkout.getPayload().ecommerce
			)
        	{
        		(data => 
        		{
        			let payload = 
            		/**
            		 * Push a place order event
            		 */
            		dataLayer.push(
    				{ 
    					event: 'placeOrder',
    					ecommerce:
    					{
    						items: AEC.Checkout.getPayload().ecommerce.items
    					}
					});

					if (AEC.tiktok && 'undefined' !== typeof ttq)
					{
						var contents = [], value = 0;
					
						AEC.Checkout.getPayload().ecommerce.items.forEach(item => 
						{
							contents.push
							(
								{
									content_id: 	item.item_id,
									content_name: 	item.item_name,
									quantity: 		item.quantity,
									brand: 			item.item_brand,
									price: 			item.price
								}
							);

							value += item.price;
						});

						AEC.TikTok.event('PlaceAnOrder', 
						{
							contents: 		contents,
							content_type:	'product',
							value: 			value,
							currency: 		AEC.currencyCode
						},
						{ 
							event_id: AEC.UUID.generate({ event: 'PlaceAnOrder'})
						});
					}
            		
        		})(AEC.Checkout.data);
        	}

            return originalAction(paymentData, messageContainer);
        });
    };
});