<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Observer;

use Magento\Framework\Event\ObserverInterface;

abstract class Cookie implements ObserverInterface
{
	/**
	 * @var \Anowave\Ec\Helper\Data
	 */
	protected $helper;
	
	/** 
	 * @var \Anowave\Ec\Model\Cookie\PrivateData
	 */
	protected $privateData;

	/**
	 * @var \Anowave\Ec\Helper\Json
	 */
	protected $jsonHelper;

	/**
	 * @var \Magento\Framework\App\Request\Http
	 */
	protected $request;
	
	/**
	 * Cosntructor 
	 * 
	 * @param \Anowave\Ec\Helper\Data $helper
	 * @param \Anowave\Ec\Model\Cookie\PrivateData $privateData
	 * @param \Anowave\Ec\Helper\Json $jsonHelper
	 * @param \Magento\Framework\App\Request\Http $request
	 */
	public function __construct
	(
		\Anowave\Ec\Helper\Data $helper,
		\Anowave\Ec\Model\Cookie\PrivateData $privateData,
		\Anowave\Ec\Helper\Json $jsonHelper,
		\Magento\Framework\App\Request\Http $request
	)
	{
		/**
		 * Set helper 
		 * 
		 * @var \Anowave\Ec\Helper\Data $helper
		 */
		$this->helper = $helper;
		
		/**
		 * Set private data 
		 * 
		 * @var \Anowave\Ec\Model\Cookie\PrivateData $privateData
		 */
		$this->privateData = $privateData;
		
		/**
		 * JSON helper 
		 * 
		 * @var \Anowave\Ec\Helper\Json $jsonHelper
		 */
		$this->jsonHelper = $jsonHelper;
		
		/**
		 * Set request
		 * 
		 * @var\Magento\Framework\App\Request\Http $request
		 */
		$this->request = $request;
	}
}
