<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Endpoints\Ltr;

use OpenSearch\Exception\RuntimeException;
use OpenSearch\Endpoints\AbstractEndpoint;

/**
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class CreateModelFromSet extends AbstractEndpoint
{
    protected $name;
    protected $store;

    public function getURI(): string
    {
        if (!isset($this->name) || $this->name === '') {
            throw new RuntimeException('name is required for create_model_from_set');
        }
        $name = $this->name;
        $store = $this->store ?? null;
        if (isset($store)) {
            return '/_ltr/' . rawurlencode($store) . '/_featureset/' . rawurlencode($name) . '/_createmodel';
        }
        return '/_ltr/_featureset/' . rawurlencode($name) . '/_createmodel';
    }

    public function getParamWhitelist(): array
    {
        return [
            'routing',
            'pretty',
            'human',
            'error_trace',
            'source',
            'filter_path'
        ];
    }

    public function getMethod(): string
    {
        return 'POST';
    }

    public function setBody($body): static
    {
        if (is_null($body)) {
            return $this;
        }
        $this->body = $body;

        return $this;
    }

    public function setName($name): static
    {
        if (is_null($name)) {
            return $this;
        }
        $this->name = $name;

        return $this;
    }

    public function setStore($store): static
    {
        if (is_null($store)) {
            return $this;
        }
        $this->store = $store;

        return $this;
    }
}
