<?php
namespace Magento\Sales\Api\Data;

/**
 * ExtensionInterface class for @see \Magento\Sales\Api\Data\OrderItemInterface
 */
interface OrderItemExtensionInterface extends \Magento\Framework\Api\ExtensionAttributesInterface
{
    /**
     * @return \Magento\GiftMessage\Api\Data\MessageInterface|null
     */
    public function getGiftMessage();

    /**
     * @param \Magento\GiftMessage\Api\Data\MessageInterface $giftMessage
     * @return $this
     */
    public function setGiftMessage(\Magento\GiftMessage\Api\Data\MessageInterface $giftMessage);

    /**
     * @return \Magento\Tax\Api\Data\OrderTaxItemInterface[]|null
     */
    public function getItemizedTaxes();

    /**
     * @param \Magento\Tax\Api\Data\OrderTaxItemInterface[] $itemizedTaxes
     * @return $this
     */
    public function setItemizedTaxes($itemizedTaxes);

    /**
     * @return string|null
     */
    public function getDesignId();

    /**
     * @param string $designId
     * @return $this
     */
    public function setDesignId($designId);
}
