<?php
namespace Magento\Quote\Api\Data;

/**
 * ExtensionInterface class for @see \Magento\Quote\Api\Data\AddressInterface
 */
interface AddressExtensionInterface extends \Magento\Framework\Api\ExtensionAttributesInterface
{
    /**
     * @return string|null
     */
    public function getPickupLocationCode();

    /**
     * @param string $pickupLocationCode
     * @return $this
     */
    public function setPickupLocationCode($pickupLocationCode);

    /**
     * @return \Magento\SalesRule\Api\Data\RuleDiscountInterface[]|null
     */
    public function getDiscounts();

    /**
     * @param \Magento\SalesRule\Api\Data\RuleDiscountInterface[] $discounts
     * @return $this
     */
    public function setDiscounts($discounts);

    /**
     * @return string|null
     */
    public function getDeliveryDay();

    /**
     * @param string $deliveryDay
     * @return $this
     */
    public function setDeliveryDay($deliveryDay);

    /**
     * @return string|null
     */
    public function getDeliveryHoursFrom();

    /**
     * @param string $deliveryHoursFrom
     * @return $this
     */
    public function setDeliveryHoursFrom($deliveryHoursFrom);

    /**
     * @return string|null
     */
    public function getDeliveryMinutesFrom();

    /**
     * @param string $deliveryMinutesFrom
     * @return $this
     */
    public function setDeliveryMinutesFrom($deliveryMinutesFrom);

    /**
     * @return string|null
     */
    public function getDeliveryHoursTo();

    /**
     * @param string $deliveryHoursTo
     * @return $this
     */
    public function setDeliveryHoursTo($deliveryHoursTo);

    /**
     * @return string|null
     */
    public function getDeliveryMinutesTo();

    /**
     * @param string $deliveryMinutesTo
     * @return $this
     */
    public function setDeliveryMinutesTo($deliveryMinutesTo);

    /**
     * @return string|null
     */
    public function getDeliveryComment();

    /**
     * @param string $deliveryComment
     * @return $this
     */
    public function setDeliveryComment($deliveryComment);

    /**
     * @return string|null
     */
    public function getDeliveryTime();

    /**
     * @param string $deliveryTime
     * @return $this
     */
    public function setDeliveryTime($deliveryTime);

    /**
     * @return string|null
     */
    public function getDeliveryOptionId();

    /**
     * @param string $deliveryOptionId
     * @return $this
     */
    public function setDeliveryOptionId($deliveryOptionId);

    /**
     * @return string|null
     */
    public function getQuoteAddressId();

    /**
     * @param string $quoteAddressId
     * @return $this
     */
    public function setQuoteAddressId($quoteAddressId);
}
