<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Api;

use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use MageWorx\ShippingRules\Model\Region;

/**
 * Extended Region CRUD interface.
 *
 * @api
 */
interface RegionRepositoryInterface
{
    /**
     * Save region.
     *
     * @param Region $region
     * @return Region
     * @throws LocalizedException
     */
    public function save(Region $region);

    /**
     * Retrieve region.
     *
     * @param int $regionId
     * @return Region
     * @throws LocalizedException
     */
    public function getById($regionId);

    /**
     * Retrieve regions matching the specified criteria.
     *
     * @param SearchCriteriaInterface $searchCriteria
     * @return SearchResultsInterface
     * @throws LocalizedException
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete region.
     *
     * @param Region $region
     * @return bool true on success
     * @throws LocalizedException
     */
    public function delete(Region $region);

    /**
     * Delete region by ID.
     *
     * @param int $regionId
     * @return bool true on success
     * @throws NoSuchEntityException
     * @throws LocalizedException
     */
    public function deleteById($regionId);

    /**
     * Get empty Region
     *
     * @return Region|Data\RegionInterface
     */
    public function getEmptyEntity();
}
