<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */
declare(strict_types = 1);

namespace MageWorx\ShippingRules\Api;

use Magento\Eav\Api\Data\AttributeInterface;

/**
 * Manage customer attributes availability in shipping rules conditions
 */
interface CustomerAttributesFilterInterface
{
    /**
     * Check is attribute disabled for conditions
     *
     * @param AttributeInterface $attribute
     * @return bool
     */
    public function check(AttributeInterface $attribute): bool;
}
