<?php
/**
 * Anowave Magento 2 Google Tag Manager Enhanced Ecommerce (UA) Tracking
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * https://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Ec
 * @copyright 	Copyright (c) 2025 Anowave (https://www.anowave.com/)
 * @license  	https://www.anowave.com/license-agreement/
 */

namespace Anowave\Ec\Plugin;

class Renderer
{
    /**
     * @var \Anowave\Ec\Helper\Dom
     */
    protected $dom;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var Base url
     */
    private $url = null;
    
    /**
     * @var \Magento\Framework\View\Element\BlockFactory
     */
    protected $blockFactory;

    /**
     * @var \Anowave\Ec\Helper\Data
     */
    protected $helper;
    
    /**
     * Constructor 
     * 
     * @param \Magento\Framework\View\Element\BlockFactory $blockFactory
     * @param \Anowave\Ec\Helper\Dom
     * @param \Magento\Store\Model\StoreManagerInterface
     * @param \Anowave\Ec\Helper\Data
     */
    public function __construct
    (
        \Magento\Framework\View\Element\BlockFactory $blockFactory,
        \Anowave\Ec\Helper\Dom $dom,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Anowave\Ec\Helper\Data $helper
    )
    {
        $this->blockFactory = $blockFactory;
        $this->dom = $dom;
        $this->storeManager = $storeManager;
        $this->helper = $helper;

        $this->url = $this->storeManager->getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_WEB);
    }
    
    /**
     * After assets render 
     * 
     * @param \Magento\Framework\View\Page\Config\Renderer $context
     * @param unknown $assets
     * @return string
     */
    public function afterRenderAssets(\Magento\Framework\View\Page\Config\Renderer $context, $assets)
    {
        if ($this->helper->useAutoTagging() && $this->helper->supportCookieDirective())
        {
            list($doc, $dom) = $this->getDom();

            $dom->loadHTML($assets);
            
            $query = new \DOMXPath($dom);

            foreach($query->query('//script') as $script)
            {
                $src = (string) $script->getAttribute('src');

                if ($src && false === strpos($src, $this->url))
                {
                    $script->setAttribute('type', 'text/plain');
                    $script->setAttribute('data-consent','cookieConsentGranted');
                }
            }

            $assets = $this->dom->getDOMContent($dom, $doc);
        }

        return $assets;
    }

    public function getDom() : array
	{
	    return 
	    [
	        new \Anowave\Ec\Model\Dom('1.0','utf-8'), 
	        new \Anowave\Ec\Model\Dom('1.0','utf-8')
	    ];
	}
}