<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use MageWorx\ShippingRules\Model\Carrier;
use Zend_Db_Expr;

class CreateRatesCodesFromIds207 implements DataPatchInterface, PatchVersionInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /** {@inheritdoc} */
    public static function getDependencies()
    {
        return [
            AddDefaultValuesForDefaultRegions160::class
        ];
    }

    /** {@inheritdoc} */
    public static function getVersion()
    {
        return '2.0.7';
    }

    /** {@inheritdoc} */
    public function apply()
    {
        $connection = $this->moduleDataSetup->getConnection();
        $ratesTable = $this->moduleDataSetup->getTable(Carrier::RATE_TABLE_NAME);
        $connection->update(
            $ratesTable,
            ['rate_code' => new Zend_Db_Expr("CONCAT('rate_',`rate_id`)")],
            ["`rate_code` IS NULL OR `rate_code` = ''"]
        );
    }

    /** {@inheritdoc} */
    public function getAliases()
    {
        return [];
    }
}
