<?php
/**
 * Copyright © MageWorx. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace MageWorx\ShippingRules\Api;

use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use MageWorx\ShippingRules\Model\Rule;

/**
 * Extended Rule CRUD interface.
 *
 * @api
 */
interface RuleRepositoryInterface
{
    /**
     * Save rule.
     *
     * @param Rule $rule
     * @return Rule
     * @throws LocalizedException
     */
    public function save(Rule $rule);

    /**
     * Retrieve rule.
     *
     * @param int $ruleId
     * @return Rule
     * @throws LocalizedException
     */
    public function getById($ruleId);

    /**
     * Retrieve rules matching the specified criteria.
     *
     * @param SearchCriteriaInterface $searchCriteria
     * @return SearchResultsInterface
     * @throws LocalizedException
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete rule.
     *
     * @param Rule $rule
     * @return bool true on success
     * @throws LocalizedException
     */
    public function delete(Rule $rule);

    /**
     * Delete rule by ID.
     *
     * @param int $ruleId
     * @return bool true on success
     * @throws NoSuchEntityException
     * @throws LocalizedException
     */
    public function deleteById($ruleId);

    /**
     * Get empty rule
     *
     * @return Rule|Data\RuleInterface
     */
    public function getEmptyEntity();
}
